unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Edit1   : TEdit;
    bttResume: TButton;
    bttSuspend: TButton;
    bttTerminate: TButton;
    Timer1: TTimer;
    bttCreate: TButton;
    Label1: TLabel;
    Label2: TLabel;
    stxtTime: TStaticText;
    stxtPi: TStaticText;
    Label3: TLabel;
    stxtCount: TStaticText;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure bttResumeClick(Sender: TObject);
    procedure bttSuspendClick(Sender: TObject);
    procedure bttTerminateClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bttCreateClick(Sender: TObject);
    procedure ShowResult();
  private
    { Private declarations }
  public
    { Public declarations }

  end;

TMyThread = class(TThread)
  private

  protected
    procedure Execute(); override;
  public

  end;

const
//      ,    
UpdatePeriod = 100001;

var
  Form1    : TForm1;
  MyThread : TMyThread;

  GlobalPi      : Extended;
  GlobalCounter : Int64;

implementation

{$R *.dfm}

procedure TMyThread.Execute();
var sign : Integer;
    PiValue, PrevValue : Extended;
    i    : Int64;
begin
  PiValue := 4;
  sign := -1;
  i := 0;
  repeat
     Inc(i);
     PrevValue := PiValue;
     PiValue := PiValue + sign * 4 / (2*i+1);
     sign := -sign;
     if i mod UpdatePeriod = 0 then
     begin
       GlobalPi := PiValue;
       GlobalCounter := i;
       Synchronize(Form1.ShowResult);
     end;
  until Terminated or (Abs(PiValue - PrevValue)<1E-19);
end;

procedure TForm1.ShowResult;
begin
 if IsIconic(Application.Handle) then  Exit;
 stxtPi.Caption := FloatToStrF(GlobalPi, ffFixed, 18, 18);
 stxtCount.Caption := IntToStr(GlobalCounter);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Edit1.Text := '  ';
 //  
 bttCreate.Enabled := True;
 bttTerminate.Enabled := False;
 bttResume.Enabled := False;
 bttSuspend.Enabled := False;
end;

procedure TForm1.bttResumeClick(Sender: TObject);
begin
 MyThread.Resume;
 Edit1.Text := ' Resume  ';
 //  
 bttCreate.Enabled := False;
 bttTerminate.Enabled := True;
 bttResume.Enabled := False;
 bttSuspend.Enabled := True;
end;

procedure TForm1.bttSuspendClick(Sender: TObject);
begin
  MyThread.Suspend;
  MyThread.Priority:=tpLowest;
  Edit1.Text := ' Suspend  . Priority : tpLowest';
  //  
  bttCreate.Enabled := False;
  bttTerminate.Enabled := True;
  bttResume.Enabled := True;
  bttSuspend.Enabled := False;
end;

procedure TForm1.bttTerminateClick(Sender: TObject);
begin
  MyThread.Terminate;
  Edit1.Text := ' Terminate  ';
  //  
  bttCreate.Enabled := False;
  bttTerminate.Enabled := False;
  bttResume.Enabled := False;
  bttSuspend.Enabled := False;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Timer1.Interval := 500;
  stxtTime.Caption := TimeToStr(Now());
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if MyThread <> nil then MyThread.Destroy;
end;

procedure TForm1.bttCreateClick(Sender: TObject);
begin
 MyThread := TMyThread.Create(True);
 Form1.Edit1.Text := '    Suspend';
 //  
 bttCreate.Enabled := False;
 bttTerminate.Enabled := True;
 bttResume.Enabled := True;
 bttSuspend.Enabled := False;
end;

end.
